CONTAINER VPhairtrace
{
	NAME VPhairtrace;
	INCLUDE VPbase;

	GROUP HAIR_RENDER_GROUP_RENDER
	{
		GROUP
		{
			COLUMNS 2;
			
			LONG HAIR_RENDER_TYPE
			{
				CYCLE
				{
					HAIR_RENDER_TYPE_RASTER_8BIT;
					HAIR_RENDER_TYPE_RASTER_32BIT;
					HAIR_RENDER_TYPE_RASTER_POST;
					HAIR_RENDER_TYPE_RAYTRACED;
				}
			}		

			LONG HAIR_RENDER_COLOR_SAMPLING
			{
				CYCLE
				{
					HAIR_RENDER_COLOR_SAMPLING_FULL;
					HAIR_RENDER_COLOR_SAMPLING_VERTEX;
					HAIR_RENDER_COLOR_SAMPLING_ROOTTIP;
				}
			}
			STATICTEXT { NEWLINE; }
		}

		SEPARATOR HAIR_RENDER_SEPARATOR_A { LINE; }
		
		GROUP
		{
			COLUMNS 2;
			
			LONG HAIR_RENDER_AA_QUALITY
			{
				CYCLE
				{
					HAIR_RENDER_AA_QUALITY_NONE;
					HAIR_RENDER_AA_QUALITY_LOW;
					HAIR_RENDER_AA_QUALITY_MED;
					HAIR_RENDER_AA_QUALITY_HIGH;
					HAIR_RENDER_AA_QUALITY_BEST;
					HAIR_RENDER_AA_QUALITY_USER;
				}
			}
			
			LONG HAIR_RENDER_AA_MODE
			{
				CYCLE
				{
					HAIR_RENDER_AA_MODE_OLD;
					HAIR_RENDER_AA_MODE_NEW;
					HAIR_RENDER_AA_MODE_SUBPIXEL;
				}
			}
		}
		
		REAL HAIR_RENDER_AA_USER { UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR HAIR_RENDER_SEPARATOR_B { LINE; }

		BOOL HAIR_RENDER_SHADOWS { }
		BOOL HAIR_RENDER_TRANSPARENCY { }
		BOOL HAIR_RENDER_TRACING { }

		SEPARATOR HAIR_RENDER_SEPARATOR_C { LINE; }

		GROUP
		{
			COLUMNS 2;	

			LONG HAIR_RENDER_MEMORY_USE
			{
				CYCLE
				{
					HAIR_RENDER_MEMORY_USE_LOW;
					HAIR_RENDER_MEMORY_USE_MED;
					HAIR_RENDER_MEMORY_USE_HIGH;
					HAIR_RENDER_MEMORY_USE_MAX;
				}
			}

			STATICTEXT { NEWLINE; }
		}
	}

	GROUP HAIR_RENDER_GROUP_SHADOWS
	{
		LONG HAIR_RENDER_SHADOW_TYPE
		{
			CYCLE
			{
				HAIR_RENDER_SHADOW_TYPE_NONE;
				HAIR_RENDER_SHADOW_TYPE_AUTO;
				HAIR_RENDER_SHADOW_TYPE_SOFT;
				HAIR_RENDER_SHADOW_TYPE_HARD;
			}
		}
		
		SEPARATOR HAIR_RENDER_SEPARATOR_D { }

		REAL HAIR_RENDER_SHADOW_TRANS_ACCURACY { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL HAIR_RENDER_SHADOW_DIST_ACCURACY { UNIT METER; MIN 0.0; }

		SEPARATOR HAIR_RENDER_SEPARATOR_E { LINE; }

		LONG HAIR_RENDER_SHADOW_AA_LEVEL
		{
			CYCLE
			{
				HAIR_RENDER_AA_QUALITY_NONE;
				HAIR_RENDER_AA_QUALITY_LOW;
				HAIR_RENDER_AA_QUALITY_MED;
				HAIR_RENDER_AA_QUALITY_HIGH;
				HAIR_RENDER_AA_QUALITY_BEST;
				HAIR_RENDER_AA_QUALITY_USER;
			}
		}
		
		REAL HAIR_RENDER_SHADOW_AA_USER { UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		
		LONG HAIR_RENDER_SHADOW_SAMPLE_SIZE { MIN 0; MAX 65536; }
		
		GROUP
		{
			COLUMNS 2;	

			LONG HAIR_RENDER_SHADOWS_MAP
			{
				CYCLE
				{
					HAIR_RENDER_SHADOWS_MAP_250;
					HAIR_RENDER_SHADOWS_MAP_500;
					HAIR_RENDER_SHADOWS_MAP_750;
					HAIR_RENDER_SHADOWS_MAP_1000;
					HAIR_RENDER_SHADOWS_MAP_1250;
					HAIR_RENDER_SHADOWS_MAP_1500;
					HAIR_RENDER_SHADOWS_MAP_1750;
					HAIR_RENDER_SHADOWS_MAP_2000;
					HAIR_RENDER_SHADOWS_MAP_CUSTOM;
				}
			}
			STATICTEXT { NEWLINE; }
		}

		LONG HAIR_RENDER_SHADOW_CACHE_SIZE { MIN 64; MAX 65536; }

		SEPARATOR HAIR_RENDER_SEPARATOR_F { LINE; }

		REAL HAIR_RENDER_SHADOW_WIDTH { UNIT DEGREE; MIN 0.0; MAX 89.0; }
	}

	GROUP HAIR_RENDER_GROUP_LIGHTS
	{
		SCALE_V;

		LONG HAIR_RENDER_LIGHTS_MODE
		{
			CYCLE
			{
				HAIR_RENDER_MODE_INCLUDE;
				HAIR_RENDER_MODE_EXCLUDE;
			}
		}

		IN_EXCLUDE  HAIR_RENDER_LIGHTS
		{
			NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1; SCALE_V;
			ACCEPT { Olight; };
		}
	}

	GROUP HAIR_RENDER_GROUP_OBJECTS
	{
		SCALE_V;

		GROUP
		{
			GROUP
			{
				COLUMNS 2;

				BOOL HAIR_RENDER_OBJECTS_HAIR { }
				BOOL HAIR_RENDER_OBJECTS_POLYGON { }
				
				BOOL HAIR_RENDER_OBJECTS_SPLINE { }
				BOOL HAIR_RENDER_OBJECTS_PARTICLE { }
			}

			SEPARATOR { }

			GROUP
			{
				COLUMNS 2;

				REAL HAIR_RENDER_HAIR_LENGTH { UNIT METER; MIN 0.0; }
				LONG HAIR_RENDER_HAIR_COUNT { MIN 0; }
			}
		}

		SEPARATOR { LINE; }

		LONG HAIR_RENDER_OBJECTS_MODE
		{
			CYCLE
			{
				HAIR_RENDER_MODE_INCLUDE;
				HAIR_RENDER_MODE_EXCLUDE;
			}
		}

		IN_EXCLUDE  HAIR_RENDER_OBJECTS
		{
			NUM_FLAGS 1; INIT_STATE 1; SEND_SELCHNGMSG 1; SCALE_V;
			IMAGE_01_ON 1009316; IMAGE_01_OFF 1009320;
			ACCEPT { Obase; };
		}
	}

	GROUP HAIR_RENDER_GROUP_MULTIPASS
	{
		BOOL HAIR_RENDER_MP_RGB { }

		LONG HAIR_RENDER_MP_DEPTH { CYCLE { HAIR_RENDER_MP_DEPTH_OFF; HAIR_RENDER_MP_DEPTH_ON; HAIR_RENDER_MP_DEPTH_OWN; } }
		LONG HAIR_RENDER_MP_ALPHA { CYCLE { HAIR_RENDER_MP_ALPHA_OFF; HAIR_RENDER_MP_ALPHA_ON; HAIR_RENDER_MP_ALPHA_OWN; } }
		
		BOOL HAIR_RENDER_MP_SPLIT_BACK { }

		BOOL HAIR_RENDER_MP_COLOR { }
		BOOL HAIR_RENDER_MP_DIFFUSE { }
		BOOL HAIR_RENDER_MP_SPECULAR { }
		BOOL HAIR_RENDER_MP_SECONDARY_SPECULAR { }
		BOOL HAIR_RENDER_MP_RECIEVE_SHADOW { }
		BOOL HAIR_RENDER_MP_SELF_SHADOW { }
		BOOL HAIR_RENDER_MP_ILLUMINATION { }
	}
}
